/*
 * Decompiled with CFR 0.152.
 */
package ua.BIT.keystore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.Utils.Ddec;

public class SupportUtils {
    public static final int UByteMAX_VALUE = 255;
    public static final int NANOS_IN_MILLIS = 1000000;

    public static String makeCachingFilename(Certificate certificate) {
        String str2;
        String str;
        try {
            str = certificate.getIssuerName("SERIALNUMBER");
        }
        catch (CertificateException unused) {
            str = null;
        }
        int i2 = 1;
        if (str == null) {
            byte[] issuerDN;
            for (byte b2 : issuerDN = certificate.getIssuerDN()) {
                i2 = (i2 * 167 + (b2 & 0xFF) * 5) % 8955043;
            }
            str2 = "R" + Integer.toString(i2 + 1000000);
        } else {
            StringBuilder sb = new StringBuilder(str);
            for (int i22 = 0; i22 < sb.length(); ++i22) {
                if (sb.charAt(i22) >= '0' && sb.charAt(i22) <= '9' || sb.charAt(i22) >= 'A' && sb.charAt(i22) <= 'Z' || sb.charAt(i22) >= 'a' && sb.charAt(i22) <= 'z' || sb.charAt(i22) == '-' || sb.charAt(i22) == '_') continue;
                sb.setCharAt(i22, (char)(sb.charAt(i22) % 26 + 97));
            }
            if (sb.length() > 20) {
                sb.setLength(20);
            }
            str2 = sb.toString();
        }
        try {
            return str2 + "-" + SupportUtils.getSerialAsText(certificate) + ".cer";
        }
        catch (CertificateException unused2) {
            return str2 + "-CERT.cer";
        }
    }

    public static final String getSerialAsText(Certificate cer) throws CertificateException {
        byte[] TryGetElementBuf = null;
        try {
            TryGetElementBuf = Ddec.DerGetElementBuf(cer.getEncoded(), "SSoe0I");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (TryGetElementBuf != null) {
            int i2;
            int length = TryGetElementBuf.length;
            if (length > 20) {
                i2 = length - 20;
                length = 20;
            } else {
                i2 = 0;
            }
            StringBuilder sb = new StringBuilder();
            int i22 = length * 2;
            sb.setLength(i22);
            for (int i3 = 0; i3 < i22; ++i3) {
                int i4 = TryGetElementBuf[(i3 >> 1) + i2] >> 4 - (i3 & 1) * 4 & 0xF;
                if (i4 > 9) {
                    i4 += 7;
                }
                sb.setCharAt(i3, (char)(i4 + 48));
            }
            return sb.toString();
        }
        throw new CertificateException(-9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readAllBytes(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] bArr = new byte[(int)file.length()];
            fileInputStream.read(bArr);
            byte[] byArray = bArr;
            return byArray;
        }
    }
}

