/*
 * Decompiled with CFR 0.152.
 */
package ua.BIT.keystore;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import ua.BIT.keystore.DatSlot;
import ua.BIT.keystore.KeyStoreInvalidOperationException;
import ua.BIT.keystore.MsWinFilter;
import ua.BIT.keystore.PathUtil;
import ua.BIT.keystore.SupportUtils;
import ua.BIT.keystore.Zs2Slot;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.Certificates.CertstoreCms;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.DsInvalidOperationException;
import ua.avtor.DsLib.KeyStores.KeyStore;
import ua.avtor.DsLib.KeyStores.KeyStoreException;
import ua.avtor.DsLib.KeyStores.KeyStoreInvalidPasswordException;
import ua.avtor.DsLib.KeyStores.KeyStoreLoginRequiredException;
import ua.avtor.DsLib.KeyStores.KeyStoreNotFoundException;
import ua.avtor.DsLib.KeyStores.SlotInfo;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.Transport.UriTransport;
import ua.avtor.DsLib.Utils.Ddec;

public class KeyStoreZS2
extends KeyStore {
    private CryptoAlgorithmFactory algs;
    private Zs2Slot[] slots = new Zs2Slot[0];

    public KeyStoreZS2(String str, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws IOException, DsException {
        this.algs = cryptoAlgorithmFactory;
        boolean z2 = str.indexOf(42) >= 0 || str.indexOf(63) >= 0;
        File[] fileArr = new File[]{new File(str)};
        if (z2) {
            String parent = fileArr[0].getParent();
            fileArr = new File(parent == null ? "." : parent).listFiles(new MsWinFilter(fileArr[0].getName()));
        } else if (!fileArr[0].exists()) {
            throw new FileNotFoundException(str);
        }
        for (File file : fileArr) {
            if (file.isDirectory()) continue;
            byte[] readAllBytes = SupportUtils.readAllBytes(file);
            String name = file.getName();
            int lastIndexOf = name.lastIndexOf(46);
            int nslot = this.addSlot(readAllBytes, lastIndexOf > 0 ? name.substring(0, lastIndexOf) : name);
            this.slots[nslot].fileName = file.getPath();
        }
    }

    public KeyStoreZS2(CryptoAlgorithmFactory cryptoAlgorithmFactory) {
        this.algs = cryptoAlgorithmFactory;
        try {
            this.addSlot(null, "default");
        }
        catch (DsDataCorruptedException e2) {
            throw new RuntimeException(e2);
        }
    }

    public KeyStoreZS2(byte[] bArr, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsDataCorruptedException {
        this.algs = cryptoAlgorithmFactory;
        this.addSlot(bArr, "default");
    }

    private void ensureSlot(int i2) {
        if (i2 < 0 || i2 >= this.slots.length) {
            throw new IllegalArgumentException();
        }
    }

    public static CertstoreCms getCertificateChainCMP(UriTransport uriTransport, String str, byte[] bArr, boolean z2) throws IOException {
        return DatSlot.RequestCmpServer(uriTransport, str, bArr, null, z2 ? 2 : 1);
    }

    public int addSlot(byte[] bArr, String str) throws DsDataCorruptedException {
        int length = this.slots.length;
        Zs2Slot zs2Slot = new Zs2Slot(bArr, str, this.algs);
        Zs2Slot[] zs2SlotArr = this.slots;
        Zs2Slot[] zs2SlotArr2 = new Zs2Slot[zs2SlotArr.length + 1];
        System.arraycopy(zs2SlotArr, 0, zs2SlotArr2, 0, zs2SlotArr.length);
        this.slots = zs2SlotArr2;
        zs2SlotArr2[length] = zs2Slot;
        return length;
    }

    @Override
    public void changePassword(int i2, String str, String str2) throws KeyStoreException {
        this.ensureSlot(i2);
        try {
            if (!this.slots[i2].changePassword(str, str2)) {
                throw new KeyStoreInvalidPasswordException();
            }
        }
        catch (DsAlgorithmException e2) {
            throw new KeyStoreException("changePassword", e2);
        }
    }

    @Override
    public String[] enumLabels(int i2) throws KeyStoreException {
        this.ensureSlot(i2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i22 = 0; i22 < this.slots[i2].bagsLength; ++i22) {
            arrayList.add(this.slots[i2].getBagLabel(i22));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public int[] enumSlots(boolean z2) throws KeyStoreException {
        int length = this.slots.length;
        int[] iArr = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            iArr[i2] = i2;
        }
        return iArr;
    }

    public int findAssociatedCertificates(int i2, String str) {
        if (i2 < this.slots.length) {
            int i22 = 0;
            int i3 = 0;
            while (true) {
                Zs2Slot[] zs2SlotArr;
                if (i22 >= (zs2SlotArr = this.slots).length) {
                    return i3;
                }
                if (i2 < 0 || i2 == i22) {
                    i3 += zs2SlotArr[i22].findExternalCertificates(str);
                }
                ++i22;
            }
        }
        throw new IllegalArgumentException();
    }

    public int findAssociatedCertificatesByCMP(int i2, UriTransport uriTransport, String str) {
        if (i2 < this.slots.length) {
            int i22 = 0;
            int i3 = 0;
            while (true) {
                Zs2Slot[] zs2SlotArr;
                if (i22 >= (zs2SlotArr = this.slots).length) {
                    return i3;
                }
                if (i2 < 0 || i2 == i22) {
                    i3 += zs2SlotArr[i22].findExternalCertificatesCMP(uriTransport, str);
                }
                ++i22;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int findSlot(String str) throws KeyStoreException {
        if (str != null && str.length() != 0) {
            for (int i2 = 0; i2 < this.slots.length; ++i2) {
                if (!(str.charAt(0) == '@' ? this.slots[i2].description.toLowerCase().startsWith(str.substring(1).toLowerCase()) : this.slots[i2].description.toLowerCase().equals(str.toLowerCase()))) continue;
                return i2;
            }
            throw new KeyStoreNotFoundException();
        }
        if (this.slots.length > 0) {
            return 0;
        }
        throw new KeyStoreNotFoundException();
    }

    @Override
    public int findSlot(Certificate certificate) throws KeyStoreException {
        Zs2Slot[] zs2SlotArr2;
        byte[] subjectKeyIdentifier = certificate.getSubjectKeyIdentifier();
        int i2 = 0;
        if (subjectKeyIdentifier != null) {
            Zs2Slot[] zs2SlotArr;
            for (int i22 = 0; i22 < (zs2SlotArr = this.slots).length; ++i22) {
                int keyByKeyIdentifier = zs2SlotArr[i22].keyByKeyIdentifier(subjectKeyIdentifier);
                if (keyByKeyIdentifier < 0) continue;
                this.slots[i22].trySuitableCertificate(keyByKeyIdentifier, certificate);
                return i22;
            }
        }
        byte[] publicKeyInfo = certificate.getPublicKeyInfo();
        while (i2 < (zs2SlotArr2 = this.slots).length) {
            int keyByPublic = zs2SlotArr2[i2].keyByPublic(publicKeyInfo);
            if (keyByPublic >= 0) {
                this.slots[i2].trySuitableCertificate(keyByPublic, certificate);
                return i2;
            }
            ++i2;
        }
        throw new KeyStoreNotFoundException();
    }

    @Override
    public int findSlot(byte[] bArr) throws KeyStoreException {
        block4: {
            Zs2Slot[] zs2SlotArr2;
            int i2;
            block3: {
                Zs2Slot[] zs2SlotArr;
                if (bArr[0] == 4) break block3;
                for (i2 = 0; i2 < (zs2SlotArr = this.slots).length; ++i2) {
                    if (zs2SlotArr[i2].keyByCertId(bArr) < 0) continue;
                    return i2;
                }
                break block4;
            }
            byte[] TryGetElementBuf = Ddec.TryGetElementBuf(bArr, "Q");
            if (TryGetElementBuf == null) break block4;
            while (i2 < (zs2SlotArr2 = this.slots).length) {
                if (zs2SlotArr2[i2].keyByKeyIdentifier(TryGetElementBuf) >= 0) {
                    return i2;
                }
                ++i2;
            }
        }
        throw new KeyStoreNotFoundException();
    }

    public Certificate getCertificate(int i2, PrivateKey privateKey) throws KeyStoreException {
        if (i2 < this.slots.length) {
            try {
                byte[] publicKeyInfo = privateKey.getPublicKeyInfo();
                int i22 = 0;
                while (true) {
                    int certByPublic;
                    Zs2Slot[] zs2SlotArr;
                    if (i22 >= (zs2SlotArr = this.slots).length) {
                        return null;
                    }
                    if ((i2 < 0 || i2 == i22) && (certByPublic = zs2SlotArr[i22].certByPublic(publicKeyInfo)) >= 0) {
                        return this.slots[i22].getCert(certByPublic);
                    }
                    ++i22;
                }
            }
            catch (DsException e2) {
                throw new KeyStoreException("getCertificate", e2);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Certificate[] getCertificateChain(Certificate cert) {
        boolean flag;
        if (cert.isSelfSigned()) {
            return new Certificate[0];
        }
        Certificate[] array = new Certificate[16];
        int newSize = 0;
        block0: do {
            flag = false;
            for (int index = 0; index < this.slots.length; ++index) {
                for (int bagIx = 0; bagIx < this.slots[index].bagsLength; ++bagIx) {
                    Certificate cert1 = this.slots[index].getCert(bagIx);
                    if (!cert1.isSignerOf(cert)) continue;
                    cert = cert1;
                    array[newSize++] = cert;
                    flag = true;
                    break;
                }
                if (flag) continue block0;
            }
        } while (flag && !cert.isSelfSigned() && newSize < 16);
        return Arrays.copyOf(array, newSize);
    }

    @Override
    public Certificate[] getCertificates(int i2, boolean z2, int i22, String str) {
        if (i2 < this.slots.length) {
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            for (int i3 = 0; i3 < this.slots.length; ++i3) {
                if (i2 >= 0 && i2 != i3) continue;
                for (int i4 = 0; i4 < this.slots[i3].bagsLength; ++i4) {
                    Certificate cert = this.slots[i3].getCert(i4);
                    if (cert == null) continue;
                    byte ku = cert.getKu();
                    if ((i22 & 4) != 0 && (ku & 6) == 0 || (i22 & 1) != 0 && (ku & 0xC0) == 0 || (i22 & 2) != 0 && (ku & 0x38) == 0 || str != null && !cert.getPublicKeyAlgOid().startsWith(str)) continue;
                    if (z2) {
                        int i5 = -1;
                        byte[] subjectKeyIdentifier = cert.getSubjectKeyIdentifier();
                        if (subjectKeyIdentifier != null) {
                            i5 = this.slots[i3].keyByKeyIdentifier(subjectKeyIdentifier);
                        }
                        if (i5 < 0) {
                            i5 = this.slots[i3].keyByPublic(cert.getPublicKeyInfo());
                        }
                        if (i5 < 0) {
                            // empty if block
                        }
                    }
                    arrayList.add(cert);
                }
            }
            return arrayList.toArray(new Certificate[arrayList.size()]);
        }
        throw new IllegalArgumentException();
    }

    public byte[] getEncoded(int i2) throws KeyStoreException {
        this.ensureSlot(i2);
        try {
            return this.slots[i2].getEncoded();
        }
        catch (DsAlgorithmException e2) {
            throw new KeyStoreException("getEncoded", e2);
        }
    }

    public byte[] getKeyIdentifier(int i2, String str) {
        this.ensureSlot(i2);
        byte[] keyIdByLabel = this.slots[i2].keyIdByLabel(str);
        return keyIdByLabel != null ? (byte[])keyIdByLabel.clone() : keyIdByLabel;
    }

    @Override
    public PrivateKey getPrivateKey(int i2, String str) throws KeyStoreException {
        this.ensureSlot(i2);
        return this.makeKey(i2, this.slots[i2].keyByLabel(str));
    }

    @Override
    public PrivateKey getPrivateKey(int i2, Certificate certificate) throws KeyStoreException {
        int i22;
        this.ensureSlot(i2);
        byte[] subjectKeyIdentifier = certificate.getSubjectKeyIdentifier();
        if (subjectKeyIdentifier != null) {
            i22 = this.slots[i2].keyByKeyIdentifier(subjectKeyIdentifier);
            if (i22 >= 0) {
                this.slots[i2].trySuitableCertificate(i22, certificate);
            }
        } else {
            i22 = -1;
        }
        if (i22 < 0 && (i22 = this.slots[i2].keyByPublic(certificate.getPublicKeyInfo())) >= 0) {
            this.slots[i2].trySuitableCertificate(i22, certificate);
        }
        return this.makeKey(i2, i22);
    }

    @Override
    public PrivateKey getPrivateKey(int i2, byte[] bArr) throws KeyStoreException {
        byte[] TryGetElementBuf;
        this.ensureSlot(i2);
        int i22 = bArr[0] == 4 ? ((TryGetElementBuf = Ddec.TryGetElementBuf(bArr, "Q")) != null ? this.slots[i2].keyByKeyIdentifier(TryGetElementBuf) : -1) : this.slots[i2].keyByCertId(bArr);
        return this.makeKey(i2, i22);
    }

    @Override
    public SlotInfo getSlotInfo(int i2) throws KeyStoreException {
        this.ensureSlot(i2);
        SlotInfo slotInfo = new SlotInfo();
        slotInfo.description = this.slots[i2].description;
        slotInfo.label = "";
        slotInfo.serial = "";
        slotInfo.flags = 73;
        if (!this.slots[i2].empty) {
            slotInfo.flags |= 0x4080;
        }
        slotInfo.minPasswordLength = 6;
        slotInfo.maxPasswordLength = 64;
        slotInfo.hardware = false;
        slotInfo.pinpad = false;
        return slotInfo;
    }

    @Override
    public boolean isLoggedIn(int i2) throws KeyStoreException {
        this.ensureSlot(i2);
        return this.slots[i2].isLoggedIn();
    }

    @Override
    public void login(int i2, String str) throws KeyStoreException {
        this.ensureSlot(i2);
        try {
            if (!this.slots[i2].login(str)) {
                throw new KeyStoreInvalidPasswordException();
            }
        }
        catch (DsAlgorithmException e2) {
            throw new KeyStoreException("login", e2);
        }
    }

    @Override
    public void logout(int i2) throws KeyStoreException {
        this.ensureSlot(i2);
        try {
            this.slots[i2].logout();
        }
        catch (DsAlgorithmException e2) {
            throw new KeyStoreException("logout", e2);
        }
    }

    public PrivateKey makeKey(int i2, int i22) throws KeyStoreException {
        if (i22 >= 0) {
            byte[] pkcs8data = this.slots[i2].pkcs8data(i22);
            if (pkcs8data != null) {
                PrivateKey signerAlg = this.algs.getSignerAlg(pkcs8data, null, -1, null);
                if (signerAlg != null) {
                    return signerAlg;
                }
                throw new KeyStoreException("Key loading error", new DsAlgorithmException());
            }
            throw new KeyStoreLoginRequiredException();
        }
        throw new KeyStoreNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAssociatedCertificates(int i2, String str) throws IOException {
        if (i2 < this.slots.length) {
            for (int i22 = 0; i22 < this.slots.length; ++i22) {
                if (i2 >= 0 && i2 != i22) continue;
                for (int i3 = 0; i3 < this.slots[i22].bagsLength; ++i3) {
                    Certificate cert = this.slots[i22].getCert(i3);
                    if (cert == null) continue;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(PathUtil.combine(str, SupportUtils.makeCachingFilename(cert)));){
                        fileOutputStream.write(cert.getEncoded());
                        continue;
                    }
                }
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    public void updateSlot(int i2) throws KeyStoreException, IOException {
        this.ensureSlot(i2);
        if (this.slots[i2].fileName != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(this.slots[i2].fileName);
            try {
                fileOutputStream.write(this.slots[i2].getEncoded());
                fileOutputStream.close();
            }
            catch (DsAlgorithmException e2) {
                throw new KeyStoreException("updateSlot", e2);
            }
            catch (Throwable th) {
                fileOutputStream.close();
                throw th;
            }
        } else {
            throw new KeyStoreInvalidOperationException("memory slot", new DsInvalidOperationException("memory slot"));
        }
    }
}

