/*
 * Decompiled with CFR 0.152.
 */
package ua.BIT.keystore;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import ua.BIT.keystore.JksSlot;
import ua.BIT.keystore.KeyStoreInvalidOperationException;
import ua.BIT.keystore.MsWinFilter;
import ua.BIT.keystore.SupportUtils;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.DsInvalidOperationException;
import ua.avtor.DsLib.KeyStores.KeyStore;
import ua.avtor.DsLib.KeyStores.KeyStoreException;
import ua.avtor.DsLib.KeyStores.KeyStoreInvalidPasswordException;
import ua.avtor.DsLib.KeyStores.KeyStoreLoginRequiredException;
import ua.avtor.DsLib.KeyStores.KeyStoreNotFoundException;
import ua.avtor.DsLib.KeyStores.SlotInfo;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.Utils.Ddec;

public class KeyStoreJKS
extends KeyStore {
    private CryptoAlgorithmFactory algs;
    private JksSlot[] slots = new JksSlot[0];

    public KeyStoreJKS(String str, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws IOException, DsException {
        this.algs = cryptoAlgorithmFactory;
        boolean z2 = str.indexOf(42) >= 0 || str.indexOf(63) >= 0;
        File[] fileArr = new File[]{new File(str)};
        if (z2) {
            String parent = fileArr[0].getParent();
            fileArr = new File(parent == null ? "." : parent).listFiles(new MsWinFilter(fileArr[0].getName()));
        } else if (!fileArr[0].exists()) {
            throw new FileNotFoundException(str);
        }
        for (File file : fileArr) {
            if (file.isDirectory()) continue;
            byte[] readAllBytes = SupportUtils.readAllBytes(file);
            String name = file.getName();
            int lastIndexOf = name.lastIndexOf(46);
            int nslot = this.addSlot(readAllBytes, lastIndexOf > 0 ? name.substring(0, lastIndexOf) : name);
            this.slots[nslot].fileName = file.getPath();
        }
    }

    public KeyStoreJKS(CryptoAlgorithmFactory cryptoAlgorithmFactory) {
        this.algs = cryptoAlgorithmFactory;
        try {
            this.addSlot(null, "default");
        }
        catch (DsDataCorruptedException e2) {
            throw new RuntimeException(e2);
        }
    }

    public KeyStoreJKS(byte[] bArr, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsDataCorruptedException {
        this.algs = cryptoAlgorithmFactory;
        this.addSlot(bArr, "default");
    }

    private void ensureSlot(int i2) {
        if (i2 < 0 || i2 >= this.slots.length) {
            throw new IllegalArgumentException();
        }
    }

    private PrivateKey makeKey(int i2, int i22) throws KeyStoreException {
        if (i22 >= 0) {
            byte[] pkcs8Key = this.slots[i2].getPkcs8Key(i22);
            if (pkcs8Key != null) {
                PrivateKey signerAlg = this.algs.getSignerAlg(pkcs8Key, null, -1, null);
                if (signerAlg != null) {
                    return signerAlg;
                }
                throw new KeyStoreException("Key loading error", new DsAlgorithmException());
            }
            throw new KeyStoreLoginRequiredException();
        }
        throw new KeyStoreNotFoundException();
    }

    public int addSlot(byte[] bArr, String str) throws DsDataCorruptedException {
        int length = this.slots.length;
        JksSlot jksSlot = new JksSlot(bArr, str, this.algs);
        JksSlot[] jksSlotArr = this.slots;
        JksSlot[] jksSlotArr2 = new JksSlot[jksSlotArr.length + 1];
        System.arraycopy(jksSlotArr, 0, jksSlotArr2, 0, jksSlotArr.length);
        this.slots = jksSlotArr2;
        jksSlotArr2[length] = jksSlot;
        return length;
    }

    @Override
    public String[] enumLabels(int i2) throws KeyStoreException {
        this.ensureSlot(i2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i22 = 0; i22 < this.slots[i2].getEntriesCount(); ++i22) {
            if (this.slots[i2].getEntryType(i22) != 1) continue;
            arrayList.add(this.slots[i2].getEntryLabel(i22));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public int[] enumSlots(boolean z2) throws KeyStoreException {
        int length = this.slots.length;
        int[] iArr = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            iArr[i2] = i2;
        }
        return iArr;
    }

    @Override
    public int findSlot(String str) throws KeyStoreException {
        if (str != null && str.length() != 0) {
            for (int i2 = 0; i2 < this.slots.length; ++i2) {
                if (!(str.charAt(0) == '@' ? this.slots[i2].description.toLowerCase().startsWith(str.substring(1).toLowerCase()) : this.slots[i2].description.toLowerCase().equals(str.toLowerCase()))) continue;
                return i2;
            }
            throw new KeyStoreNotFoundException();
        }
        if (this.slots.length > 0) {
            return 0;
        }
        throw new KeyStoreNotFoundException();
    }

    @Override
    public int findSlot(Certificate certificate) throws KeyStoreException {
        byte[] subjectKeyIdentifier = certificate.getSubjectKeyIdentifier();
        int i2 = 0;
        if (subjectKeyIdentifier != null) {
            JksSlot[] jksSlotArr;
            for (int i22 = 0; i22 < (jksSlotArr = this.slots).length; ++i22) {
                if (jksSlotArr[i22].keyByKeyIdentifier(subjectKeyIdentifier) < 0) continue;
                return i22;
            }
        }
        byte[] publicKeyInfo = certificate.getPublicKeyInfo();
        while (true) {
            JksSlot[] jksSlotArr2;
            if (i2 >= (jksSlotArr2 = this.slots).length) {
                throw new KeyStoreNotFoundException();
            }
            if (jksSlotArr2[i2].keyByPublic(publicKeyInfo) >= 0) {
                return i2;
            }
            ++i2;
        }
    }

    @Override
    public int findSlot(byte[] bArr) throws KeyStoreException {
        block4: {
            JksSlot[] jksSlotArr2;
            int i2;
            block3: {
                JksSlot[] jksSlotArr;
                if (bArr[0] == 4) break block3;
                for (i2 = 0; i2 < (jksSlotArr = this.slots).length; ++i2) {
                    if (jksSlotArr[i2].keyByCertId(bArr) < 0) continue;
                    return i2;
                }
                break block4;
            }
            byte[] TryGetElementBuf = Ddec.TryGetElementBuf(bArr, "Q");
            if (TryGetElementBuf == null) break block4;
            while (i2 < (jksSlotArr2 = this.slots).length) {
                if (jksSlotArr2[i2].keyByKeyIdentifier(TryGetElementBuf) >= 0) {
                    return i2;
                }
                ++i2;
            }
        }
        throw new KeyStoreNotFoundException();
    }

    public Certificate getCertificate(int i2, PrivateKey privateKey) throws KeyStoreException {
        if (i2 < this.slots.length) {
            try {
                byte[] publicKeyInfo = privateKey.getPublicKeyInfo();
                int i22 = 0;
                while (true) {
                    int certByPublic;
                    JksSlot[] jksSlotArr;
                    if (i22 >= (jksSlotArr = this.slots).length) {
                        return null;
                    }
                    if ((i2 < 0 || i2 == i22) && (certByPublic = jksSlotArr[i22].certByPublic(publicKeyInfo)) >= 0) {
                        try {
                            byte[] entryCertificate = this.slots[i22].getEntryCertificate(certByPublic, 0);
                            if (entryCertificate != null) {
                                return new Certificate(entryCertificate);
                            }
                            throw new CertificateException(-1);
                        }
                        catch (CertificateException certificateException) {
                            // empty catch block
                        }
                    }
                    ++i22;
                }
            }
            catch (DsException e2) {
                throw new KeyStoreException("getCertificate", e2);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Certificate[] getCertificates(int i2, boolean z2, int i22, String str) throws KeyStoreException {
        if (i2 < this.slots.length) {
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            for (int i3 = 0; i3 < this.slots.length; ++i3) {
                if (i2 >= 0 && i2 != i3) continue;
                for (int i4 = 0; i4 < this.slots[i3].getEntriesCount(); ++i4) {
                    if (this.slots[i3].getEntryType(i4) == 1) {
                        try {
                            Certificate certificate = new Certificate(this.slots[i3].getEntryCertificate(i4, 0));
                            byte ku = certificate.getKu();
                            if (!((i22 & 4) != 0 && (ku & 6) == 0 || (i22 & 1) != 0 && (ku & 0xC0) == 0 || (i22 & 2) != 0 && (ku & 0x38) == 0 || str != null && !certificate.getPublicKeyAlgOid().startsWith(str))) {
                                arrayList.add(certificate);
                            }
                        }
                        catch (CertificateException certificateException) {
                            // empty catch block
                        }
                    }
                    this.slots[i3].getEntryType(i4);
                }
            }
            return arrayList.toArray(new Certificate[arrayList.size()]);
        }
        throw new IllegalArgumentException();
    }

    public byte[] getEncoded(int i2) throws KeyStoreException {
        this.ensureSlot(i2);
        try {
            return this.slots[i2].getEncoded();
        }
        catch (DsAlgorithmException e2) {
            throw new KeyStoreException("getEncoded", e2);
        }
    }

    public byte[] getKeyIdentifier(int i2, String str) {
        this.ensureSlot(i2);
        byte[] keyIdByLabel = this.slots[i2].keyIdByLabel(str);
        return keyIdByLabel != null ? (byte[])keyIdByLabel.clone() : keyIdByLabel;
    }

    @Override
    public PrivateKey getPrivateKey(int i2, String str) throws KeyStoreException {
        this.ensureSlot(i2);
        return this.makeKey(i2, this.slots[i2].keyByLabel(str));
    }

    @Override
    public PrivateKey getPrivateKey(int i2, Certificate certificate) throws KeyStoreException {
        this.ensureSlot(i2);
        return this.makeKey(i2, this.slots[i2].keyByPublic(certificate.getPublicKeyInfo()));
    }

    @Override
    public PrivateKey getPrivateKey(int i2, byte[] bArr) throws KeyStoreException {
        this.ensureSlot(i2);
        return this.makeKey(i2, this.slots[i2].keyByCertId(bArr));
    }

    @Override
    public SlotInfo getSlotInfo(int i2) throws KeyStoreException {
        this.ensureSlot(i2);
        SlotInfo slotInfo = new SlotInfo();
        slotInfo.description = this.slots[i2].description;
        slotInfo.label = "";
        slotInfo.serial = "";
        slotInfo.flags = 65;
        if (!this.slots[i2].empty) {
            slotInfo.flags |= 0x4080;
        }
        slotInfo.minPasswordLength = 8;
        slotInfo.maxPasswordLength = 64;
        slotInfo.hardware = false;
        slotInfo.pinpad = false;
        return slotInfo;
    }

    @Override
    public boolean isLoggedIn(int i2) throws KeyStoreException {
        this.ensureSlot(i2);
        return this.slots[i2].isLoggedIn();
    }

    @Override
    public void login(int i2, String str) throws KeyStoreException {
        this.ensureSlot(i2);
        if (!this.slots[i2].login(str)) {
            throw new KeyStoreInvalidPasswordException();
        }
    }

    @Override
    public void logout(int i2) throws KeyStoreException {
        this.ensureSlot(i2);
        this.slots[i2].logout();
    }

    public void updateSlot(int i2) throws KeyStoreException, IOException {
        this.ensureSlot(i2);
        if (this.slots[i2].fileName != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(this.slots[i2].fileName);
            try {
                fileOutputStream.write(this.slots[i2].getEncoded());
                fileOutputStream.close();
            }
            catch (DsAlgorithmException e2) {
                throw new KeyStoreException("updateSlot", e2);
            }
            catch (Throwable th) {
                fileOutputStream.close();
                throw th;
            }
        } else {
            throw new KeyStoreInvalidOperationException("memory slot", new DsInvalidOperationException("memory slot"));
        }
    }
}

