/*
 * Decompiled with CFR 0.152.
 */
package ua.BIT.keystore;

import java.io.File;
import java.util.Arrays;
import ua.BIT.keystore.KeyStoreDAT;
import ua.BIT.keystore.KeyStoreJKS;
import ua.BIT.keystore.KeyStoreZS2;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsInvalidParamException;
import ua.avtor.DsLib.KeyStores.KeyStore;
import ua.avtor.DsLib.KeyStores.KeyStoreException;
import ua.avtor.DsLib.KeyStores.KeyStoreNotFoundException;
import ua.avtor.DsLib.KeyStores.KeyStorePKCS11;
import ua.avtor.DsLib.KeyStores.KeyStorePKCS12;
import ua.avtor.DsLib.Utils.Ddec;

public class KeyStoreFactory {
    CryptoAlgorithmFactory algs;

    public KeyStoreFactory(CryptoAlgorithmFactory cryptoAlgorithmFactory) {
        this.algs = cryptoAlgorithmFactory;
    }

    private String extractParam(String str, String str2) {
        int i4;
        int i2;
        int length = str.length();
        int length2 = str2.length();
        int i22 = 1;
        while (true) {
            if (i22 >= length) break;
            int i3 = i22 + length2;
            if (i3 < length && str.charAt(i3) == '=') {
                int c2 = 0;
                for (i2 = 0; i2 < length2; ++i2) {
                    c2 = (char)(c2 | (str.charAt(i22 + i2) | 0x20) ^ (str2.charAt(i2) | 0x20));
                }
                if (c2 == 0) {
                    i2 = i3 + 1;
                    break;
                }
            }
            while (i22 < length && str.charAt(i22) != '&') {
                ++i22;
            }
            ++i22;
        }
        if (i2 == 0) {
            return "";
        }
        for (i4 = i2; i4 < str.length() && str.charAt(i4) != '&'; ++i4) {
        }
        return str.substring(i2, i4);
    }

    public KeyStore openKeyData(byte[] keyBlob) throws KeyStoreNotFoundException {
        try {
            return new KeyStorePKCS12(keyBlob, this.algs);
        }
        catch (DsDataCorruptedException dsDataCorruptedException) {
            try {
                return new KeyStoreZS2(keyBlob, this.algs);
            }
            catch (DsDataCorruptedException dsDataCorruptedException2) {
                try {
                    return new KeyStoreJKS(keyBlob, this.algs);
                }
                catch (DsDataCorruptedException dsDataCorruptedException3) {
                    try {
                        byte[] key11Blob = null;
                        if (keyBlob.length > 64 && keyBlob[0] == 48 && Ddec.DerGetTotalSize(keyBlob) < keyBlob.length) {
                            int totalSize = Ddec.DerGetTotalSize(keyBlob);
                            key11Blob = new byte[keyBlob.length - totalSize];
                            System.arraycopy(keyBlob, totalSize, key11Blob, 0, keyBlob.length - totalSize);
                            keyBlob = Arrays.copyOf(keyBlob, totalSize);
                        }
                        return new KeyStoreDAT(keyBlob, key11Blob, this.algs);
                    }
                    catch (DsDataCorruptedException dsDataCorruptedException4) {
                        throw new KeyStoreNotFoundException("unrecognized", new DsDataCorruptedException());
                    }
                }
            }
        }
    }

    public KeyStore openKeyFile(String fileName) throws KeyStoreNotFoundException {
        File f2;
        if (fileName == null || "".equals(fileName.trim())) {
            throw new KeyStoreNotFoundException();
        }
        if (fileName.startsWith("?")) {
            String message = this.extractParam(fileName, "KS");
            if (message.equals("PKCS11")) {
                String libraryList = this.extractParam(fileName, "libs");
                try {
                    return new KeyStorePKCS11(libraryList);
                }
                catch (KeyStoreException ex) {
                    throw new KeyStoreNotFoundException("", ex);
                }
            }
            if (!message.equals("FILE")) {
                throw new KeyStoreNotFoundException(message, new DsInvalidParamException());
            }
            fileName = this.extractParam(fileName, "name");
        }
        if (!(f2 = new File(fileName)).exists()) {
            throw new KeyStoreNotFoundException();
        }
        if (f2.length() > 5120000L) {
            throw new KeyStoreNotFoundException("oversize", new DsDataCorruptedException());
        }
        try {
            String ext = KeyStoreFactory.getFileExtension(f2).toLowerCase().trim();
            if (ext.length() > 0) {
                if (".pfx,.p12".contains(ext)) {
                    KeyStorePKCS12 keyStore = new KeyStorePKCS12(fileName, this.algs);
                    ((KeyStore)keyStore).getSlotInfo(0);
                    return keyStore;
                }
                if (".dat".contains(ext)) {
                    KeyStoreDAT keyStore = new KeyStoreDAT(fileName, this.algs);
                    ((KeyStore)keyStore).getSlotInfo(0);
                    return keyStore;
                }
                if (".zs2".contains(ext)) {
                    KeyStoreZS2 keyStore = new KeyStoreZS2(fileName, this.algs);
                    ((KeyStore)keyStore).getSlotInfo(0);
                    return keyStore;
                }
                if (".jks".contains(ext)) {
                    KeyStoreJKS keyStore = new KeyStoreJKS(fileName, this.algs);
                    ((KeyStore)keyStore).getSlotInfo(0);
                    return keyStore;
                }
            }
        }
        catch (Throwable ext) {
            // empty catch block
        }
        try {
            KeyStorePKCS12 keyStore = new KeyStorePKCS12(fileName, this.algs);
            ((KeyStore)keyStore).getSlotInfo(0);
            return keyStore;
        }
        catch (Throwable keyStore) {
            try {
                KeyStoreZS2 keyStore2 = new KeyStoreZS2(fileName, this.algs);
                ((KeyStore)keyStore2).getSlotInfo(0);
                return keyStore2;
            }
            catch (Throwable keyStore2) {
                try {
                    KeyStoreDAT keyStore3 = new KeyStoreDAT(fileName, this.algs);
                    ((KeyStore)keyStore3).getSlotInfo(0);
                    return keyStore3;
                }
                catch (Throwable keyStore3) {
                    try {
                        KeyStoreJKS keyStore4 = new KeyStoreJKS(fileName, this.algs);
                        ((KeyStore)keyStore4).getSlotInfo(0);
                        return keyStore4;
                    }
                    catch (Throwable throwable) {
                        throw new KeyStoreNotFoundException("unrecognized", new DsDataCorruptedException());
                    }
                }
            }
        }
    }

    private static String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }
}

