/*
 * Decompiled with CFR 0.152.
 */
package ua.BIT.keystore;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import ua.BIT.keystore.DatSlot;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.KeyStores.KeyStoreException;
import ua.avtor.DsLib.Utils.ArrayUtil;
import ua.avtor.DsLib.Utils.Ddec;

class JksSlot {
    private CryptoAlgorithmFactory algs;
    private String cachedPsw;
    private byte[] data;
    public String description;
    public boolean empty;
    public String fileName;
    private ArrayList<KeystoreJksKey> keys = new ArrayList();
    private boolean loggedIn;
    public boolean modified;

    public JksSlot(byte[] bArr, String str, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsDataCorruptedException {
        boolean z2;
        this.algs = cryptoAlgorithmFactory;
        this.description = str;
        this.loggedIn = false;
        this.modified = false;
        this.empty = z2 = bArr == null;
        if (!z2) {
            this.data = (byte[])bArr.clone();
            if (this.Be4(0) == -17957139 && this.Be4(4) == 2) {
                for (int i2 = 0; i2 < this.getJksEntryCount(); ++i2) {
                    if (this.getJksEntryType(i2) != 1) continue;
                    int certSubIx1 = 0;
                    byte[] entryCertificate = this.getJksEntryCertificate(i2, certSubIx1);
                    while (entryCertificate != null) {
                        int num = 0;
                        try {
                            num = new Certificate(entryCertificate).getKu();
                        }
                        catch (CertificateException certificateException) {
                            // empty catch block
                        }
                        if ((num & 0xC0) != 0) {
                            KeystoreJksKey ks = new KeystoreJksKey();
                            ks.label = this.getJksEntryLabel(i2) + "_s";
                            ks.entryIx = i2;
                            ks.keySubIx = 0;
                            ks.certSubIx = certSubIx1;
                            this.keys.add(ks);
                        }
                        entryCertificate = this.getJksEntryCertificate(i2, ++certSubIx1);
                    }
                    int certSubIx2 = 0;
                    byte[] entryCertificate2 = this.getJksEntryCertificate(i2, certSubIx2);
                    while (entryCertificate2 != null) {
                        int num = 0;
                        try {
                            num = new Certificate(entryCertificate2).getKu();
                        }
                        catch (CertificateException certificateException) {
                            // empty catch block
                        }
                        if ((num & 0x38) != 0) {
                            KeystoreJksKey ks = new KeystoreJksKey();
                            ks.label = this.getJksEntryLabel(i2) + "_e";
                            ks.entryIx = i2;
                            ks.keySubIx = 1;
                            ks.certSubIx = certSubIx2;
                            this.keys.add(ks);
                        }
                        entryCertificate2 = this.getJksEntryCertificate(i2, ++certSubIx2);
                    }
                }
                return;
            }
            throw new DsDataCorruptedException();
        }
    }

    private static byte[] ArrayExtract(byte[] bArr, int i2, int i22) {
        byte[] bArr2 = new byte[i22];
        System.arraycopy(bArr, i2, bArr2, 0, i22);
        return bArr2;
    }

    private int Be4(int i2) {
        byte[] bArr = this.data;
        return bArr[i2 + 3] & 0xFF | (bArr[i2 + 0] & 0xFF) << 24 | (bArr[i2 + 1] & 0xFF) << 16 | (bArr[i2 + 2] & 0xFF) << 8;
    }

    private byte[] getJksEntryCertificate(int i2, int i22) {
        if (i2 >= this.getJksEntryCount()) {
            return null;
        }
        try {
            RefInt refInt = new RefInt(this.getJksEntryPosition(i2));
            int readInt = this.readInt(refInt);
            this.readName(refInt);
            this.readTime(refInt);
            if (readInt == 1) {
                this.readDer(refInt);
                int readInt2 = this.readInt(refInt);
                for (int i3 = 0; i3 < readInt2; ++i3) {
                    this.readName(refInt);
                    byte[] readDer = this.readDer(refInt);
                    if (i3 != i22) continue;
                    return readDer;
                }
            } else if (readInt == 2) {
                this.readName(refInt);
                return this.readDer(refInt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private int getJksEntryCount() {
        if (this.empty) {
            return 0;
        }
        return this.Be4(8);
    }

    private String getJksEntryLabel(int i2) throws DsDataCorruptedException {
        if (i2 >= this.getJksEntryCount()) {
            return null;
        }
        return this.readName(new RefInt(this.getJksEntryPosition(i2) + 4));
    }

    private int getJksEntryPosition(int i2) throws DsDataCorruptedException {
        RefInt refInt = new RefInt(12);
        while (i2 > 0) {
            int readInt = this.readInt(refInt);
            this.readName(refInt);
            this.readTime(refInt);
            if (readInt == 1) {
                this.readDer(refInt);
                int readInt2 = this.readInt(refInt);
                for (int i22 = 0; i22 < readInt2; ++i22) {
                    this.readName(refInt);
                    this.readDer(refInt);
                }
            } else if (readInt == 2) {
                this.readName(refInt);
                this.readDer(refInt);
            }
            --i2;
        }
        return refInt.v;
    }

    private int getJksEntryType(int i2) throws DsDataCorruptedException {
        if (i2 >= this.getJksEntryCount()) {
            return 0;
        }
        return this.readInt(new RefInt(this.getJksEntryPosition(i2)));
    }

    public int certByPublic(byte[] bArr) {
        if (bArr == null) {
            return -1;
        }
        try {
            byte[] TryGetElementBuf = Ddec.TryGetElementBuf(bArr, "SsG");
            for (int i2 = 0; i2 < this.getEntriesCount(); ++i2) {
                if (!Arrays.equals(TryGetElementBuf, new Certificate(this.getJksEntryCertificate(this.keys.get((int)i2).entryIx, this.keys.get((int)i2).certSubIx)).getPublicKey())) continue;
                return i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public byte[] decryptKey(int i2, String str) {
        try {
            RefInt refInt = new RefInt(this.getJksEntryPosition(i2));
            MessageDigestAlg digestAlg = this.algs.getDigestAlg("1.3.14.3.2.26", null, null);
            if (this.readInt(refInt) != 1) {
                return null;
            }
            this.readName(refInt);
            this.readTime(refInt);
            byte[] TryGetElementBuf = Ddec.TryGetElementBuf(this.readDer(refInt), "SsQ");
            if (TryGetElementBuf != null && TryGetElementBuf.length > 40) {
                byte[] AsBigEndianUnicode = ArrayUtil.AsBigEndianUnicode(str);
                byte[] ArrayExtract = JksSlot.ArrayExtract(TryGetElementBuf, 0, 20);
                byte[] ArrayExtract2 = JksSlot.ArrayExtract(TryGetElementBuf, 20, TryGetElementBuf.length - 40);
                int i22 = 0;
                while (i22 < ArrayExtract2.length) {
                    digestAlg.update(AsBigEndianUnicode);
                    digestAlg.update(ArrayExtract);
                    ArrayExtract = digestAlg.getDigest();
                    for (int i3 = 0; i3 < 20; ++i3) {
                        if (i22 >= ArrayExtract2.length) continue;
                        ArrayExtract2[i22] = (byte)(ArrayExtract2[i22] ^ ArrayExtract[i3]);
                        ++i22;
                    }
                }
                digestAlg.update(AsBigEndianUnicode);
                digestAlg.update(ArrayExtract2);
                if (!Arrays.equals(digestAlg.getDigest(), JksSlot.ArrayExtract(TryGetElementBuf, TryGetElementBuf.length - 20, 20))) {
                    return null;
                }
                return ArrayExtract2;
            }
            return null;
        }
        catch (DsDataCorruptedException dsDataCorruptedException) {
            return null;
        }
    }

    public byte[] getEncoded() throws DsAlgorithmException, KeyStoreException {
        return (byte[])this.data.clone();
    }

    public int getEntriesCount() {
        return this.keys.size();
    }

    public byte[] getEntryCertificate(int i2, int i22) {
        if (i2 >= this.getEntriesCount() || i22 > 0) {
            return null;
        }
        return this.getJksEntryCertificate(this.keys.get((int)i2).entryIx, this.keys.get((int)i2).certSubIx);
    }

    public String getEntryLabel(int i2) {
        if (i2 >= this.getEntriesCount()) {
            return null;
        }
        return this.keys.get((int)i2).label;
    }

    public int getEntryType(int i2) {
        return i2 >= this.getEntriesCount() ? 0 : 1;
    }

    public byte[] getPkcs8Key(int i2) {
        byte[] decryptKey = this.decryptKey(this.keys.get((int)i2).entryIx, this.cachedPsw);
        if (decryptKey == null || this.keys.get((int)i2).keySubIx == 0) {
            return decryptKey;
        }
        if (this.keys.get((int)i2).keySubIx == 1) {
            return DatSlot.ParseEncryptionKey(decryptKey);
        }
        return null;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean isTwoKeyEntry(int i2) throws DsDataCorruptedException {
        byte[] jksEntryCertificate = this.getJksEntryCertificate(i2, 0);
        byte[] jksEntryCertificate2 = this.getJksEntryCertificate(i2, 1);
        if (jksEntryCertificate2 == null) {
            return false;
        }
        try {
            return Arrays.equals(new Certificate(jksEntryCertificate).getSubjectDN(), new Certificate(jksEntryCertificate2).getSubjectDN());
        }
        catch (CertificateException unused) {
            return false;
        }
    }

    public int keyByCertId(byte[] bArr) {
        for (int i2 = 0; i2 < this.getEntriesCount(); ++i2) {
            try {
                if (!new Certificate(this.getJksEntryCertificate(this.keys.get((int)i2).entryIx, this.keys.get((int)i2).certSubIx)).isMyIdentifier(bArr)) continue;
                return i2;
            }
            catch (Exception unused) {
                return -1;
            }
        }
        return -1;
    }

    public int keyByKeyIdentifier(byte[] bArr) {
        for (int i2 = 0; i2 < this.getEntriesCount(); ++i2) {
            try {
                if (!Arrays.equals(new Certificate(this.getJksEntryCertificate(this.keys.get((int)i2).entryIx, this.keys.get((int)i2).certSubIx)).getSubjectKeyIdentifier(), bArr)) continue;
                return i2;
            }
            catch (Exception unused) {
                return -1;
            }
        }
        return -1;
    }

    public int keyByLabel(String str) {
        for (int i2 = 0; i2 < this.getEntriesCount(); ++i2) {
            if (!str.equals(this.keys.get((int)i2).label)) continue;
            return i2;
        }
        return -1;
    }

    public int keyByPublic(byte[] bArr) {
        try {
            byte[] TryGetElementBuf = Ddec.TryGetElementBuf(bArr, "SsG");
            for (int i2 = 0; i2 < this.getEntriesCount(); ++i2) {
                if (!Arrays.equals(TryGetElementBuf, new Certificate(this.getJksEntryCertificate(this.keys.get((int)i2).entryIx, this.keys.get((int)i2).certSubIx)).getPublicKey())) continue;
                return i2;
            }
            return -1;
        }
        catch (Exception unused) {
            return -1;
        }
    }

    public byte[] keyIdByLabel(String str) {
        for (int i2 = 0; i2 < this.getEntriesCount(); ++i2) {
            try {
                if (!str.equals(this.keys.get((int)i2).label)) continue;
                return new Certificate(this.getJksEntryCertificate(this.keys.get((int)i2).entryIx, this.keys.get((int)i2).certSubIx)).getSubjectKeyIdentifier();
            }
            catch (Exception unused) {
                return null;
            }
        }
        return null;
    }

    public boolean login(String str) throws KeyStoreException {
        byte[] bArr = null;
        if (this.loggedIn) {
            throw new KeyStoreException("already loggedIn", null);
        }
        if (this.empty) {
            String str2 = this.cachedPsw;
            if (str2 == null || !str2.equals(str)) {
                return false;
            }
            this.loggedIn = true;
            return true;
        }
        for (int i2 = 0; i2 < this.getEntriesCount(); ++i2) {
            if (this.keys.get((int)i2).keySubIx != 0) continue;
            bArr = this.decryptKey(this.keys.get((int)i2).entryIx, str);
        }
        if (bArr == null) {
            return false;
        }
        this.cachedPsw = str;
        this.loggedIn = true;
        return true;
    }

    public void logout() {
        this.cachedPsw = null;
        this.loggedIn = false;
    }

    public byte[] readDer(RefInt refInt) throws DsDataCorruptedException {
        int Be4 = this.Be4(refInt.v);
        int i2 = refInt.v + 4;
        refInt.v = i2 + Be4;
        if (Be4 >= 0 && Be4 <= 262144) {
            return JksSlot.ArrayExtract(this.data, i2, Be4);
        }
        throw new DsDataCorruptedException();
    }

    public int readInt(RefInt refInt) {
        refInt.v += 4;
        return this.Be4(refInt.v - 4);
    }

    public String readName(RefInt refInt) {
        int i2 = ((this.data[refInt.v] & 0xFF) << 8) + (this.data[refInt.v + 1] & 0xFF);
        int i22 = refInt.v + 2;
        refInt.v = i22 + i2;
        try {
            return new String(this.data, i22, i2, "UTF8");
        }
        catch (UnsupportedEncodingException unused) {
            return null;
        }
    }

    public int readTime(RefInt refInt) {
        refInt.v += 8;
        return 0;
    }

    protected static class RefInt {
        int v;

        public RefInt(int i2) {
            this.v = i2;
        }
    }

    protected static class KeystoreJksKey {
        public int certSubIx;
        public int entryIx;
        public int keySubIx;
        public String label;

        protected KeystoreJksKey() {
        }
    }
}

