/*
 * Decompiled with CFR 0.152.
 */
package ua.BIT.keystore;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import ua.BIT.keystore.ArrayUtil;
import ua.BIT.keystore.KeyStoreInvalidOperationException;
import ua.BIT.keystore.PathUtil;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.Certificates.CertstoreCms;
import ua.avtor.DsLib.Certificates.CertstoreDir;
import ua.avtor.DsLib.CmsSigned;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.KeyStores.KeyStoreException;
import ua.avtor.DsLib.KeyStores.KeyStoreLoginRequiredException;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.Transport.HttpTransport;
import ua.avtor.DsLib.Transport.UriTransport;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DerEncoder;
import ua.kiev.author.cryptolib.Gost28147;
import ua.kiev.author.cryptolib.Gost34311;

class DatSlot {
    private CryptoAlgorithmFactory algs;
    public int bagsLength = 2;
    private String cachedPsw;
    private byte[] decryptedKey;
    public String description;
    public boolean empty;
    private byte[] encryptedKey;
    private Certificate[] externalCerts = new Certificate[]{null, null};
    public String fileName;
    private byte[] keyidInfo;
    private byte[][] kids = new byte[][]{null, null};
    private boolean loggedIn;
    public boolean modified;
    private byte[][] pkcs8keys = new byte[][]{null, null};
    private byte[][] pubkeys = new byte[][]{null, null};

    public DatSlot(byte[] bArr, byte[] bArr2, String str, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsDataCorruptedException {
        this.algs = cryptoAlgorithmFactory;
        this.description = str;
        this.loggedIn = false;
        this.empty = bArr == null;
        this.bagsLength = 2;
        if (bArr == null) {
            return;
        }
        if (bArr.length < 64 || Ddec.DerGetTotalSize(bArr) != bArr.length) {
            throw new DsDataCorruptedException();
        }
        String TryGetElementOid = Ddec.TryGetElementOid(bArr, "SSD");
        if (TryGetElementOid == null || !TryGetElementOid.equals("1.3.6.1.4.1.19398.1.1.1.2")) {
            throw new DsDataCorruptedException();
        }
        this.encryptedKey = bArr;
        if (bArr2 != null && bArr2.length >= 80 && bArr2[0] == 1) {
            this.keyidInfo = bArr2;
            if (bArr2[4] == 0 || bArr2[8] == 0) {
                this.bagsLength = 1;
            }
            byte[][] bArr3 = this.kids;
            bArr3[0] = new byte[32];
            System.arraycopy(bArr2, 16, bArr3[0], 0, 32);
            byte[][] bArr4 = this.kids;
            bArr4[1] = new byte[32];
            System.arraycopy(this.keyidInfo, 48, bArr4[1], 0, 32);
        }
    }

    private static byte[] DerGetBytes(byte[] bArr, String str) {
        return Ddec.TryGetElementBuf(bArr, str);
    }

    static byte[] ParseEncryptionKey(byte[] bArr) {
        byte[] DerGetBytes = DatSlot.DerGetBytes(bArr, "Sisqj0:1.3.6.1.4.1.19398.1.1.2.2 Us");
        byte[] DerGetBytes2 = DatSlot.DerGetBytes(DerGetBytes, "SxQ");
        DerEncoder derEncoder = new DerEncoder();
        String TryGetElementOid = Ddec.TryGetElementOid(DerGetBytes, "SD");
        if (TryGetElementOid != null) {
            derEncoder.addOid(TryGetElementOid);
        } else {
            int i2;
            int i22;
            derEncoder.SeqBegin();
            int TryGetElementInt = Ddec.TryGetElementInt(DerGetBytes, "SSoe0SI");
            int TryGetElementInt2 = Ddec.TryGetElementInt(DerGetBytes, "SSoe0SiI");
            if (TryGetElementInt2 == 0) {
                TryGetElementInt2 = Ddec.TryGetElementInt(DerGetBytes, "SSoe0SiSI");
                i22 = Ddec.TryGetElementInt(DerGetBytes, "SSoe0SiSiI");
                i2 = Ddec.TryGetElementInt(DerGetBytes, "SSoe0SiSiiI");
            } else {
                i22 = 0;
                i2 = 0;
            }
            derEncoder.SeqBegin();
            derEncoder.addInteger(TryGetElementInt);
            if (TryGetElementInt2 != 0) {
                if (i2 == 0) {
                    derEncoder.addInteger(TryGetElementInt2);
                } else {
                    derEncoder.SeqBegin();
                    derEncoder.addInteger(i2);
                    derEncoder.addInteger(i22);
                    derEncoder.addInteger(TryGetElementInt2);
                    derEncoder.SeqEnd();
                }
            }
            derEncoder.SeqEnd();
            derEncoder.addObject(Ddec.TryGetElementBuf(DerGetBytes, "SSoe0si"));
            derEncoder.addOctetsReverse(Ddec.TryGetElementBuf(DerGetBytes, "SSoe0siQ"));
            derEncoder.addObject(Ddec.TryGetElementBuf(DerGetBytes, "SSoe0siqi"));
            derEncoder.addOctetsReverse(Ddec.TryGetElementBuf(DerGetBytes, "SSoe0siqiQ"));
            derEncoder.SeqEnd();
        }
        byte[] encoded = derEncoder.getEncoded();
        byte[] DerGetBytes3 = DatSlot.DerGetBytes(bArr, "Sisqj0:1.3.6.1.4.1.19398.1.1.2.3 UG");
        ArrayUtil.bitReverse(DerGetBytes3);
        DerEncoder derEncoder2 = new DerEncoder();
        derEncoder2.SeqBegin();
        derEncoder2.addInteger(0);
        derEncoder2.SeqBegin();
        derEncoder2.addOid("1.2.804.2.1.1.1.1.3.1.1");
        derEncoder2.SeqBegin();
        derEncoder2.addObject(encoded);
        if (DerGetBytes2 != null) {
            derEncoder2.addOctets(DerGetBytes2);
        }
        derEncoder2.SeqEnd();
        derEncoder2.SeqEnd();
        derEncoder2.addOctets(DerGetBytes3);
        derEncoder2.SeqEnd();
        return derEncoder2.getEncoded();
    }

    static byte[] ParseSignatureKey(byte[] bArr) {
        byte[] DerGetBytes = DatSlot.DerGetBytes(bArr, "Sis");
        byte[] DerGetBytes2 = DatSlot.DerGetBytes(bArr, "SisQ");
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addInteger(0);
        derEncoder.addObject(DerGetBytes);
        derEncoder.addOctets(DerGetBytes2);
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    public static CertstoreCms RequestCmpServer(UriTransport uriTransport, String str, byte[] bArr, byte[] bArr2, int i2) throws IOException {
        byte[] TryGetElementBuf;
        byte[] bArr3 = new byte[120];
        bArr3[0] = 13;
        bArr3[8] = 1;
        if (bArr2 != null) {
            bArr3[8] = 2;
        }
        if (bArr != null) {
            System.arraycopy(bArr, 0, bArr3, 12, bArr.length);
        }
        if (bArr2 != null) {
            System.arraycopy(bArr2, 0, bArr3, 44, bArr2.length);
        }
        if (i2 > 0) {
            bArr3[108] = 1;
        }
        if (i2 > 1) {
            bArr3[112] = 1;
        }
        bArr3[116] = 0;
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addOid("1.2.840.113549.1.7.1");
        derEncoder.SpecificBegin((byte)-96);
        derEncoder.addOctets(bArr3);
        derEncoder.SpecificEnd();
        derEncoder.SeqEnd();
        if (uriTransport instanceof HttpTransport && !str.startsWith("http")) {
            str = "http://" + str;
        }
        if (!str.endsWith("/")) {
            str = str + "/services/cmp/";
        }
        if ((TryGetElementBuf = Ddec.TryGetElementBuf(uriTransport.post(str, derEncoder.getEncoded(), null, null), "SdE0Q")) != null && TryGetElementBuf.length > 8) {
            byte[] bArr4 = new byte[TryGetElementBuf.length - 8];
            System.arraycopy(TryGetElementBuf, 8, bArr4, 0, TryGetElementBuf.length - 8);
            try {
                return new CertstoreCms(new CmsSigned(bArr4));
            }
            catch (DsException dsException) {
                // empty catch block
            }
        }
        return null;
    }

    private Gost28147 getEncryptor(String str) {
        byte[] bArr;
        try {
            bArr = str.getBytes("Windows-1251");
        }
        catch (UnsupportedEncodingException unused) {
            bArr = str.getBytes();
        }
        Gost34311 gost34311 = new Gost34311(null, null, true);
        gost34311.Hash(bArr, bArr.length);
        ArrayUtil.clear(bArr);
        byte[] HashEnd = gost34311.HashEnd();
        for (int i2 = 0; i2 < 9999; ++i2) {
            gost34311.Hash(HashEnd, 32);
            HashEnd = gost34311.HashEnd();
        }
        gost34311.Clear();
        return new Gost28147(Gost28147.getVector("400D9F7957C1ACF28ABED466E53B28134A6334ABE5D116CCBD00F257799E882F7D11E942A7C3502C04FABB6E98D5863FD2A8E057FC13312FB5746B9E46CD098A"), HashEnd, false);
    }

    private void parseContainer() {
        this.bagsLength = 1;
        this.kids[0] = DatSlot.DerGetBytes(this.decryptedKey, "Sisqj0:1.3.6.1.4.1.19398.1.1.2.1 UQ");
        this.pkcs8keys[0] = DatSlot.ParseSignatureKey(this.decryptedKey);
        byte[] DerGetBytes = DatSlot.DerGetBytes(this.decryptedKey, "Sisqj0:1.3.6.1.4.1.19398.1.1.2.5 UQ");
        if (DerGetBytes != null) {
            this.bagsLength = 2;
            this.kids[1] = DerGetBytes;
            this.pkcs8keys[1] = DatSlot.ParseEncryptionKey(this.decryptedKey);
        }
    }

    public int certByPublic(byte[] bArr) {
        if (bArr == null) {
            return -1;
        }
        byte[] TryGetElementBuf = Ddec.TryGetElementBuf(bArr, "SsG");
        for (int i2 = 0; i2 < this.bagsLength; ++i2) {
            Certificate[] certificateArr = this.externalCerts;
            if (certificateArr[i2] == null) continue;
            try {
                if (!Arrays.equals(TryGetElementBuf, certificateArr[i2].getPublicKey())) continue;
                return i2;
            }
            catch (CertificateException unused) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean changePassword(String str, String str2) throws KeyStoreException {
        if (this.loggedIn) {
            if (!str.equals(this.cachedPsw)) {
                return false;
            }
            this.cachedPsw = str2;
            this.modified = true;
        } else if (this.empty) {
            this.cachedPsw = str2;
        } else {
            if (!this.login(str)) {
                return false;
            }
            this.cachedPsw = str2;
            this.modified = true;
            this.logout();
        }
        return true;
    }

    public int findExternalCertificates(String str) {
        if (str != null && str.length() > 0) {
            for (String str2 : str.split(";")) {
                if (str2.startsWith("*")) {
                    String string = str2 = this.fileName == null ? null : PathUtil.getDirectoryName(this.fileName) + str2.substring(1);
                }
                if (str2 == null || str2.length() <= 0) continue;
                CertstoreDir certstoreDir = new CertstoreDir(str2);
                for (int i2 = 0; i2 < this.bagsLength; ++i2) {
                    byte[] findCertificate = certstoreDir.findCertificate(1, this.kids[i2]);
                    if (findCertificate == null) continue;
                    try {
                        Certificate certificate = new Certificate(findCertificate);
                        Certificate[] certificateArr = this.externalCerts;
                        if (certificateArr[i2] != null && !certificateArr[i2].isSelfSigned()) continue;
                        this.externalCerts[i2] = certificate;
                        continue;
                    }
                    catch (CertificateException certificateException) {
                        // empty catch block
                    }
                }
            }
        }
        int i2 = 0;
        for (int i3 = 0; i3 < this.bagsLength; ++i3) {
            if (this.externalCerts[i3] == null) continue;
            ++i2;
        }
        return i2;
    }

    public int findExternalCertificatesCMP(UriTransport uriTransport, String str) {
        if (str != null && str.length() > 0) {
            for (String str2 : str.split(";")) {
                Certificate[] certificateArr2;
                boolean z2;
                CertstoreCms certstoreCms;
                if (str2 == null || str2.length() <= 0) continue;
                boolean z22 = true;
                try {
                    byte[][] bArr = this.kids;
                    certstoreCms = DatSlot.RequestCmpServer(uriTransport, str2, bArr[0], bArr[1], 0);
                }
                catch (IOException unused) {
                    certstoreCms = null;
                }
                if (certstoreCms != null) {
                    z2 = false;
                    for (int i2 = 0; i2 < this.bagsLength; ++i2) {
                        try {
                            byte[] findCertificate = certstoreCms.findCertificate(1, this.kids[i2]);
                            if (findCertificate == null) continue;
                            Certificate certificate = new Certificate(findCertificate);
                            Certificate[] certificateArr = this.externalCerts;
                            if (certificateArr[i2] == null || certificateArr[i2].isSelfSigned()) {
                                this.externalCerts[i2] = certificate;
                            }
                            z2 = true;
                            continue;
                        }
                        catch (CertificateException certificateException) {
                            // empty catch block
                        }
                    }
                } else {
                    z2 = false;
                }
                if ((certificateArr2 = this.externalCerts)[0] == null || certificateArr2[1] == null && this.bagsLength >= 2) {
                    z22 = false;
                }
                if (z2 && z22) break;
            }
        }
        int i2 = 0;
        for (int i3 = 0; i3 < this.bagsLength; ++i3) {
            if (this.externalCerts[i3] == null) continue;
            ++i2;
        }
        return i2;
    }

    public String getBagLabel(int i2) {
        return "##" + Integer.toString(i2);
    }

    public Certificate getCert(int i2) {
        if (i2 >= this.bagsLength) {
            return null;
        }
        return this.externalCerts[i2];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getEncoded() throws KeyStoreException {
        byte[] bArr6;
        if (this.modified) {
            if (!this.loggedIn) throw new KeyStoreLoginRequiredException();
            byte[] bArr = this.decryptedKey;
            if (bArr.length % 8 != 0) throw new IllegalArgumentException("assert mod8");
            int DerGetTotalSize = Ddec.DerGetTotalSize(bArr);
            byte[] bArr2 = this.decryptedKey;
            int length = bArr2.length - DerGetTotalSize;
            this.encryptedKey = (byte[])bArr2.clone();
            Gost28147 encryptor = this.getEncryptor(this.cachedPsw);
            byte[] bArr3 = new byte[4];
            byte[] bArr4 = new byte[length];
            encryptor.ClearSync();
            encryptor.MAC(this.encryptedKey, 0, DerGetTotalSize);
            encryptor.GetMAC4(bArr3, 0);
            byte[] bArr5 = this.encryptedKey;
            encryptor.M1Enc(bArr5, 0, bArr5.length);
            System.arraycopy(this.encryptedKey, DerGetTotalSize, bArr4, 0, length);
            DerEncoder derEncoder = new DerEncoder();
            derEncoder.SeqBegin();
            derEncoder.SeqBegin();
            derEncoder.addOid("1.3.6.1.4.1.19398.1.1.1.2");
            derEncoder.SeqBegin();
            derEncoder.addOctets(bArr3);
            derEncoder.addOctets(bArr4);
            derEncoder.SeqEnd();
            derEncoder.SeqEnd();
            derEncoder.addSpecific((byte)4, this.encryptedKey, DerGetTotalSize);
            derEncoder.SeqEnd();
            this.encryptedKey = derEncoder.getEncoded();
            this.modified = false;
        }
        if ((bArr6 = this.encryptedKey) == null) throw new KeyStoreInvalidOperationException("empty slot", null);
        return bArr6;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public int keyByCertId(byte[] bArr) {
        if (bArr != null && bArr.length >= 3) {
            if (bArr[0] == 48) {
                for (int i2 = 0; i2 < this.bagsLength; ++i2) {
                    Certificate[] certificateArr = this.externalCerts;
                    if (certificateArr[i2] == null || !certificateArr[i2].isMyIdentifier(bArr)) continue;
                    return i2;
                }
            } else {
                if (bArr[0] != 4) {
                    return -1;
                }
                int length = bArr.length - 2;
                byte[] bArr2 = new byte[length];
                System.arraycopy(bArr, 2, bArr2, 0, length);
                return this.keyByKeyIdentifier(bArr2);
            }
        }
        return -1;
    }

    public int keyByKeyIdentifier(byte[] bArr) {
        if (Arrays.equals(this.kids[0], bArr)) {
            return 0;
        }
        return Arrays.equals(this.kids[1], bArr) ? 1 : -1;
    }

    public int keyByLabel(String str) {
        for (int i2 = 0; i2 < this.bagsLength; ++i2) {
            if (!str.equals(this.getBagLabel(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int keyByPublic(byte[] bArr) {
        byte[] TryGetElementBuf = Ddec.TryGetElementBuf(bArr, "SsG");
        for (int i2 = 0; i2 < this.bagsLength; ++i2) {
            PrivateKey signerAlg;
            if (this.pubkeys[i2] == null && this.loggedIn && (signerAlg = this.algs.getSignerAlg(this.pkcs8data(i2), null, 0, null)) != null) {
                try {
                    this.pubkeys[i2] = Ddec.TryGetElementBuf(signerAlg.getPublicKeyInfo(), "SsG");
                }
                catch (DsException dsException) {
                    // empty catch block
                }
                signerAlg.cleanup();
            }
            if (!Arrays.equals(TryGetElementBuf, this.pubkeys[i2])) continue;
            return i2;
        }
        return -1;
    }

    public byte[] keyIdByLabel(String str) {
        for (int i2 = 0; i2 < this.bagsLength; ++i2) {
            if (!str.equals(this.getBagLabel(i2))) continue;
            return this.kids[i2];
        }
        return null;
    }

    public boolean login(String str) throws KeyStoreException {
        byte[] bArr3;
        if (this.loggedIn) {
            throw new KeyStoreException("already loggedIn", null);
        }
        if (this.empty) {
            String str2 = this.cachedPsw;
            if (str2 == null || !str2.equals(str)) {
                return false;
            }
            this.loggedIn = true;
            return true;
        }
        byte[] DerGetBytes = DatSlot.DerGetBytes(this.encryptedKey, "SsQ");
        byte[] DerGetBytes2 = DatSlot.DerGetBytes(this.encryptedKey, "SSdSQ");
        byte[] DerGetBytes3 = DatSlot.DerGetBytes(this.encryptedKey, "SSdSqQ");
        int length = DerGetBytes3 != null ? DerGetBytes3.length : 0;
        byte[] bArr = new byte[DerGetBytes.length + length];
        this.decryptedKey = bArr;
        System.arraycopy(DerGetBytes, 0, bArr, 0, DerGetBytes.length);
        if (length > 0) {
            System.arraycopy(DerGetBytes3, 0, this.decryptedKey, DerGetBytes.length, length);
        }
        Gost28147 encryptor = this.getEncryptor(str);
        byte[] bArr2 = this.decryptedKey;
        encryptor.M1Dec(bArr2, 0, bArr2.length);
        encryptor.ClearSync();
        encryptor.MAC(this.decryptedKey, 0, DerGetBytes.length);
        if (encryptor.CheckMAC4(DerGetBytes2, 0) && (bArr3 = this.decryptedKey)[0] == 48 && Ddec.DerGetTotalSize(bArr3) == DerGetBytes.length) {
            this.parseContainer();
            this.cachedPsw = str;
            this.loggedIn = true;
            return true;
        }
        return false;
    }

    public void logout() throws KeyStoreException {
        byte[][] bArr3;
        byte[][] bArr2;
        byte[] bArr;
        if (this.modified) {
            this.getEncoded();
        }
        if ((bArr = this.decryptedKey) != null) {
            ArrayUtil.clear(bArr);
        }
        if ((bArr2 = this.pkcs8keys)[0] != null) {
            ArrayUtil.clear(bArr2[0]);
        }
        if ((bArr3 = this.pkcs8keys)[1] != null) {
            ArrayUtil.clear(bArr3[1]);
        }
        this.cachedPsw = null;
        this.loggedIn = false;
    }

    public byte[] pkcs8data(int i2) {
        if (i2 >= this.bagsLength || !this.loggedIn) {
            return null;
        }
        return this.pkcs8keys[i2];
    }

    public boolean trySuitableCertificate(int i2, Certificate certificate) {
        if (i2 >= this.bagsLength) {
            return false;
        }
        Certificate[] certificateArr = this.externalCerts;
        if (certificateArr[i2] != null && !certificateArr[i2].isSelfSigned()) {
            return false;
        }
        this.externalCerts[i2] = certificate;
        return true;
    }
}

