/*
 * Decompiled with CFR 0.152.
 */
package ua.BIT;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import ua.BIT.BitHttpHandlers;

public class BitHttpServer {
    static HttpsServer server = null;
    static boolean isStarted = false;
    static ExecutorService threadPool = null;

    public static void ServerStart() throws NoSuchAlgorithmException, KeyStoreException, CertificateException, UnrecoverableKeyException, KeyManagementException, NoSuchProviderException {
        if (!isStarted) {
            try {
                server = HttpsServer.create();
                server.bind(new InetSocketAddress("127.0.0.1", 14555), 0);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                char[] password = "12345678".toCharArray();
                KeyStore ks = KeyStore.getInstance("pkcs12", "SunJSSE");
                InputStream is = BitHttpServer.class.getResourceAsStream("/localhost.pfx");
                ks.load(is, password);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, password);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ks);
                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                server.setHttpsConfigurator(new HttpsConfigurator(sslContext){

                    @Override
                    public void configure(HttpsParameters params) {
                        try {
                            SSLContext c2 = SSLContext.getDefault();
                            SSLEngine engine = c2.createSSLEngine();
                            params.setNeedClientAuth(false);
                            params.setCipherSuites(engine.getEnabledCipherSuites());
                            params.setProtocols(engine.getEnabledProtocols());
                            SSLParameters defaultSSLParameters = c2.getDefaultSSLParameters();
                            params.setSSLParameters(defaultSSLParameters);
                        }
                        catch (Exception ex) {
                            System.out.println("Failed to create HTTPS port\r\n" + ex.getMessage());
                        }
                    }
                });
                server.createContext("/GetSignMessage", new BitHttpHandlers.GetSignMessageHandler());
                server.createContext("/GetCertificateList", new BitHttpHandlers.GetCertificateListHandler());
                server.createContext("/CheckPin", new BitHttpHandlers.CheckPinHandler());
                server.createContext("/GetLastErrors", new BitHttpHandlers.GetLastErrorsHandler());
                server.createContext("/GetVersion", new BitHttpHandlers.GetVersionHandler());
                server.createContext("/Focus", new BitHttpHandlers.FocusHandler());
                threadPool = Executors.newCachedThreadPool();
                server.setExecutor(threadPool);
                server.start();
                isStarted = true;
            }
            catch (IOException ex) {
                Logger.getLogger(BitHttpServer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void ServerStop() {
        if (isStarted) {
            server.stop(0);
            threadPool.shutdownNow();
            isStarted = false;
        }
    }

    public static boolean IsStarted() {
        return isStarted;
    }
}

