/*
 * Decompiled with CFR 0.152.
 */
package ua.BIT;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpsExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ua.BIT.BIT_PKCS11Applet;
import ua.BIT.BIT_PKCS11CL3;
import ua.BIT.BITeWebCrypt;

public class BitHttpHandlers {
    static void appendJsonToBuilder(StringBuilder builder, String key, String value) {
        builder.append("\"" + key + "\": \"" + value + "\",");
    }

    static Map<String, String> getQueryMap(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    static boolean checkParameters(ArrayList<String> neededParams, Map<String, String> queryParams, String methodName) {
        boolean result = true;
        for (String ndParam : neededParams) {
            String val = BitHttpHandlers.getParam(ndParam, queryParams);
            if (val != null) continue;
            BIT_PKCS11CL3.SetError("Parameter" + ndParam + " not found", methodName);
            result = false;
        }
        return result;
    }

    static String getParam(String name, Map<String, String> queryParams) {
        for (String quParam : queryParams.keySet()) {
            if (!quParam.equalsIgnoreCase(name)) continue;
            return queryParams.get(quParam);
        }
        return null;
    }

    static class GetVersionHandler
    implements HttpHandler {
        GetVersionHandler() {
        }

        @Override
        public void handle(HttpExchange exch) throws IOException {
            HttpsExchange exchange = (HttpsExchange)exch;
            String method = exchange.getRequestMethod();
            if (method.equalsIgnoreCase("OPTIONS")) {
                Headers head = exchange.getResponseHeaders();
                head.set("Access-Control-Allow-Origin", "*");
                head.set("Access-Control-Allow-Private-Network", "true");
                exchange.sendResponseHeaders(204, -1L);
                return;
            }
            if (!method.equalsIgnoreCase("GET")) {
                exchange.sendResponseHeaders(400, -1L);
                return;
            }
            String retData = "{\"response\":1.4}";
            byte[] bytes = retData.getBytes(StandardCharsets.UTF_8);
            Headers head = exchange.getResponseHeaders();
            head.set("Access-Control-Allow-Origin", "*");
            head.set("Accept", "json");
            head.set("Content-Type", String.format("application/json; charset=%s", StandardCharsets.UTF_8));
            exchange.sendResponseHeaders(200, bytes.length);
            OutputStream os = exchange.getResponseBody();
            os.write(bytes);
            os.close();
        }
    }

    static class GetSignMessageHandler
    implements HttpHandler {
        GetSignMessageHandler() {
        }

        @Override
        public void handle(HttpExchange exch) throws IOException {
            HttpsExchange exchange = (HttpsExchange)exch;
            String method = exchange.getRequestMethod();
            if (method.equalsIgnoreCase("OPTIONS")) {
                Headers head = exchange.getResponseHeaders();
                head.set("Access-Control-Allow-Origin", "*");
                head.set("Access-Control-Allow-Private-Network", "true");
                exchange.sendResponseHeaders(204, -1L);
                return;
            }
            if (!method.equalsIgnoreCase("GET")) {
                exchange.sendResponseHeaders(400, -1L);
                return;
            }
            Headers head = exchange.getResponseHeaders();
            head.set("Access-Control-Allow-Origin", "*");
            head.set("Accept", "json");
            head.set("Content-Type", String.format("application/json; charset=%s", StandardCharsets.UTF_8));
            String query = exchange.getRequestURI().getQuery();
            HashMap<String, String> params = new HashMap();
            if (query != null) {
                params = BitHttpHandlers.getQueryMap(exchange.getRequestURI().getQuery());
            }
            ArrayList<String> neededParams = new ArrayList<String>();
            neededParams.add("nSlotID");
            neededParams.add("strType");
            neededParams.add("strPIN");
            neededParams.add("strData");
            neededParams.add("crtBase64");
            if (!BitHttpHandlers.checkParameters(neededParams, params, "GetSignMessage")) {
                exchange.sendResponseHeaders(400, 0L);
                return;
            }
            long nSlotID = Long.valueOf(BitHttpHandlers.getParam("nSlotID", params));
            String result = new BIT_PKCS11Applet().GetSignMessage(URLDecoder.decode(BitHttpHandlers.getParam("strData", params), StandardCharsets.UTF_8.name()), URLDecoder.decode(BitHttpHandlers.getParam("crtBase64", params), StandardCharsets.UTF_8.name()), nSlotID, BitHttpHandlers.getParam("strPIN", params), BitHttpHandlers.getParam("strType", params), BitHttpHandlers.getParam("strDeviceName", params));
            if (result == null) {
                result = "";
            }
            String retData = "{\"response\":\"" + result + "\"}";
            byte[] bytes = retData.getBytes(StandardCharsets.UTF_8);
            exchange.sendResponseHeaders(200, bytes.length);
            OutputStream os = exchange.getResponseBody();
            os.write(bytes);
            os.close();
        }
    }

    static class FocusHandler
    implements HttpHandler {
        FocusHandler() {
        }

        @Override
        public void handle(HttpExchange exch) throws IOException {
            HttpsExchange exchange = (HttpsExchange)exch;
            String method = exchange.getRequestMethod();
            if (method.equalsIgnoreCase("OPTIONS")) {
                Headers head = exchange.getResponseHeaders();
                head.set("Access-Control-Allow-Origin", "*");
                head.set("Access-Control-Allow-Private-Network", "true");
                exchange.sendResponseHeaders(204, -1L);
                return;
            }
            if (!method.equalsIgnoreCase("GET")) {
                exchange.sendResponseHeaders(400, -1L);
                return;
            }
            BITeWebCrypt.setVisibleMain();
            String retData = new BIT_PKCS11Applet().GetLastErrors();
            retData = "{\"response\":true}";
            byte[] bytes = retData.getBytes(StandardCharsets.UTF_8);
            Headers head = exchange.getResponseHeaders();
            head.set("Access-Control-Allow-Origin", "*");
            head.set("Accept", "json");
            head.set("Content-Type", String.format("application/json; charset=%s", StandardCharsets.UTF_8));
            exchange.sendResponseHeaders(200, bytes.length);
            OutputStream os = exchange.getResponseBody();
            os.write(bytes);
            os.close();
        }
    }

    static class GetLastErrorsHandler
    implements HttpHandler {
        GetLastErrorsHandler() {
        }

        @Override
        public void handle(HttpExchange exch) throws IOException {
            HttpsExchange exchange = (HttpsExchange)exch;
            String method = exchange.getRequestMethod();
            if (method.equalsIgnoreCase("OPTIONS")) {
                Headers head = exchange.getResponseHeaders();
                head.set("Access-Control-Allow-Origin", "*");
                head.set("Access-Control-Allow-Private-Network", "true");
                exchange.sendResponseHeaders(204, -1L);
                return;
            }
            if (!method.equalsIgnoreCase("GET")) {
                exchange.sendResponseHeaders(400, -1L);
                return;
            }
            String retData = new BIT_PKCS11Applet().GetLastErrors();
            retData = "{\"response\":\"" + retData.replaceAll("\"", "\\\\\\\"").replaceAll("[\n\r]", "") + "\"}";
            byte[] bytes = retData.getBytes(StandardCharsets.UTF_8);
            Headers head = exchange.getResponseHeaders();
            head.set("Access-Control-Allow-Origin", "*");
            head.set("Accept", "json");
            head.set("Content-Type", String.format("application/json; charset=%s", StandardCharsets.UTF_8));
            exchange.sendResponseHeaders(200, bytes.length);
            OutputStream os = exchange.getResponseBody();
            os.write(bytes);
            os.close();
        }
    }

    static class CheckPinHandler
    implements HttpHandler {
        CheckPinHandler() {
        }

        @Override
        public void handle(HttpExchange exch) throws IOException {
            HttpsExchange exchange = (HttpsExchange)exch;
            String method = exchange.getRequestMethod();
            if (method.equalsIgnoreCase("OPTIONS")) {
                Headers head = exchange.getResponseHeaders();
                head.set("Access-Control-Allow-Origin", "*");
                head.set("Access-Control-Allow-Private-Network", "true");
                exchange.sendResponseHeaders(204, -1L);
                return;
            }
            if (!method.equalsIgnoreCase("GET")) {
                exchange.sendResponseHeaders(400, -1L);
                return;
            }
            Headers head = exchange.getResponseHeaders();
            head.set("Access-Control-Allow-Origin", "*");
            head.set("Accept", "json");
            head.set("Content-Type", String.format("application/json; charset=%s", StandardCharsets.UTF_8));
            String query = exchange.getRequestURI().getQuery();
            HashMap<String, String> params = new HashMap();
            if (query != null) {
                params = BitHttpHandlers.getQueryMap(exchange.getRequestURI().getQuery());
            }
            ArrayList<String> neededParams = new ArrayList<String>();
            neededParams.add("nSlotID");
            neededParams.add("strType");
            neededParams.add("strPIN");
            if (!BitHttpHandlers.checkParameters(neededParams, params, "CheckPin")) {
                exchange.sendResponseHeaders(400, 0L);
                return;
            }
            long nSlotID = Long.valueOf(BitHttpHandlers.getParam("nSlotID", params));
            int result = new BIT_PKCS11Applet().CheckPin(nSlotID, BitHttpHandlers.getParam("strType", params), BitHttpHandlers.getParam("strPIN", params), BitHttpHandlers.getParam("strDeviceName", params));
            String retData = "{\"response\":" + result + "}";
            byte[] bytes = retData.getBytes(StandardCharsets.UTF_8);
            exchange.sendResponseHeaders(200, bytes.length);
            OutputStream os = exchange.getResponseBody();
            os.write(bytes);
            os.close();
        }
    }

    static class GetCertificateListHandler
    implements HttpHandler {
        GetCertificateListHandler() {
        }

        @Override
        public void handle(HttpExchange exch) throws IOException {
            HttpsExchange exchange = (HttpsExchange)exch;
            String method = exchange.getRequestMethod();
            if (method.equalsIgnoreCase("OPTIONS")) {
                Headers head = exchange.getResponseHeaders();
                head.set("Access-Control-Allow-Origin", "*");
                head.set("Access-Control-Allow-Private-Network", "true");
                exchange.sendResponseHeaders(204, -1L);
                return;
            }
            if (!method.equalsIgnoreCase("GET")) {
                exchange.sendResponseHeaders(400, -1L);
                return;
            }
            String query = exchange.getRequestURI().getQuery();
            Map<String, String> params = new HashMap<String, String>();
            if (query != null) {
                params = BitHttpHandlers.getQueryMap(exchange.getRequestURI().getQuery());
            }
            String pin = BitHttpHandlers.getParam("strPIN", params);
            String retData = new BIT_PKCS11Applet().GetCertificateList(pin);
            retData = "{\"response\":\"" + retData.replaceAll("\"", "\\\\\\\"").replaceAll("[\n\r]", "") + "\"}";
            byte[] bytes = retData.getBytes(StandardCharsets.UTF_8);
            Headers head = exchange.getResponseHeaders();
            head.set("Access-Control-Allow-Origin", "*");
            head.set("Accept", "json");
            head.set("Content-Type", String.format("application/json; charset=%s", StandardCharsets.UTF_8));
            exchange.sendResponseHeaders(200, bytes.length);
            OutputStream os = exchange.getResponseBody();
            os.write(bytes);
            os.close();
        }
    }

    static class GetSignMessageTestHandler
    implements HttpHandler {
        GetSignMessageTestHandler() {
        }

        @Override
        public void handle(HttpExchange exch) throws IOException {
            HttpsExchange exchange = (HttpsExchange)exch;
            String method = exchange.getRequestMethod();
            if (method.equalsIgnoreCase("OPTIONS")) {
                Headers head = exchange.getResponseHeaders();
                head.set("Access-Control-Allow-Origin", "*");
                head.set("Access-Control-Allow-Private-Network", "true");
                exchange.sendResponseHeaders(204, -1L);
                return;
            }
            if (!method.equalsIgnoreCase("GET")) {
                exchange.sendResponseHeaders(400, -1L);
                return;
            }
            StringBuilder builder = new StringBuilder();
            InputStream requestStream = exchange.getRequestBody();
            byte[] buffer = new byte[requestStream.available()];
            requestStream.read(buffer);
            String strRequest = new String(buffer, StandardCharsets.UTF_8);
            builder.append("{");
            BitHttpHandlers.appendJsonToBuilder(builder, "Request", strRequest);
            BitHttpHandlers.appendJsonToBuilder(builder, "URI", exchange.getRequestURI().toString());
            String query = exchange.getRequestURI().getQuery();
            Map<Object, Object> params = new HashMap();
            if (query != null) {
                params = BitHttpHandlers.getQueryMap(exchange.getRequestURI().getQuery());
            }
            for (Object key : params.keySet()) {
                BitHttpHandlers.appendJsonToBuilder(builder, (String)key, (String)params.get(key));
            }
            Headers headers = exchange.getRequestHeaders();
            for (String header : headers.keySet()) {
                BitHttpHandlers.appendJsonToBuilder(builder, header, headers.getFirst(header));
            }
            builder = builder.delete(builder.length() - 1, builder.length());
            builder.append("}");
            String retData = new BIT_PKCS11Applet().GetCertificateList();
            retData = "{\"response\":\"" + retData.replaceAll("\"", "'").replaceAll("[\n\r]", "") + "\"}";
            byte[] bytes = retData.getBytes();
            Headers head = exchange.getResponseHeaders();
            head.set("Access-Control-Allow-Origin", "*");
            head.set("Accept", "json");
            head.set("Content-Type", String.format("application/json; charset=%s", StandardCharsets.UTF_8));
            exchange.sendResponseHeaders(200, bytes.length);
            OutputStream os = exchange.getResponseBody();
            os.write(bytes);
            os.close();
        }
    }
}

