/*
 * Decompiled with CFR 0.152.
 */
package ua.BIT;

import java.io.File;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import ua.BIT.BIT_PKCS11CL3;
import ua.BIT.BIT_SOAP;
import ua.BIT.Holder;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.SignerInfo;

public class BIT_PKCS11Applet {
    private static BIT_PKCS11CL3 cBIT_PKCS11CL3 = null;

    public String GetCertificateList(String strPIN) {
        return cBIT_PKCS11CL3.GetCertificateListWithDevices(strPIN);
    }

    public String GetCertificateList() {
        return cBIT_PKCS11CL3.GetCertificateListWithDevices();
    }

    public boolean SendFile(String FileName, String WebURI, int FileID, int PacketSize, String StrKey) {
        return BIT_SOAP.FileRead(FileName, WebURI, FileID, PacketSize, StrKey);
    }

    public String GetLastErrors() {
        return BIT_PKCS11CL3.GetError();
    }

    public void SetMustTimeStamped(boolean bTS) {
        BIT_PKCS11CL3.bMustTimeStamped = bTS;
    }

    public void SetTSPServer(String ServerURL) {
        BIT_PKCS11CL3.TSP_SERVER_URL = ServerURL;
    }

    public void SetHTTPProxy(String IP, int Port, String User, String Password) {
        BIT_PKCS11CL3.HTTP_PROXY = IP;
        BIT_PKCS11CL3.HTTP_PROXY_PORT = Port;
        BIT_PKCS11CL3.HTTP_PROXY_USER = User;
        BIT_PKCS11CL3.HTTP_PROXY_PASSWORD = Password;
    }

    public boolean IsSetTSPServer() {
        return BIT_PKCS11CL3.IsSetTSPServer();
    }

    public boolean IsSetHTTPProxy() {
        return BIT_PKCS11CL3.IsSetHTTPProxy();
    }

    public String GetSignMessage(String strData, String crtBase64, long nSlotID, String strPIN, String strType) {
        return this.GetSignMessage(strData, crtBase64, nSlotID, strPIN, strType, null);
    }

    public String GetSignMessage(final String strData, final String crtBase64, final long nSlotID, final String strPIN, final String strType, final String strDeviceName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                SignerInfo[] arrSi;
                Holder<SignerInfo[]> si;
                byte[] content;
                cBIT_PKCS11CL3;
                byte[] crt = BIT_PKCS11CL3.getBytesFromBase64(crtBase64);
                if (crt == null || strData == null || strData.length() < 1) {
                    if (crt == null) {
                        BIT_PKCS11CL3.SetError("Can't convert Certificate from Base64", "GetSignMessage");
                    } else {
                        BIT_PKCS11CL3.SetError("Data is empty", "GetSignMessage");
                    }
                    return null;
                }
                byte[] rawData = strData.getBytes(Charset.forName("UTF-8"));
                if (rawData == null || rawData.length < 1) {
                    BIT_PKCS11CL3.SetError("Can't convert data to byte[]", "GetSignMessage");
                    return null;
                }
                Certificate cert = null;
                try {
                    cert = new Certificate(crt);
                }
                catch (Exception ex) {
                    BIT_PKCS11CL3.SetError(ex.getMessage(), "GetSignMessage");
                    return null;
                }
                if (cert == null) {
                    BIT_PKCS11CL3.SetError("Can't convert Certificate from byte[]", "GetSignMessage");
                    return null;
                }
                String strError = "";
                Holder<String> hol = new Holder<String>(strError);
                byte[] SignedData = null;
                if (strType.equalsIgnoreCase("PFX")) {
                    if (strDeviceName == null || strDeviceName == "") {
                        BIT_PKCS11CL3.SetError("Missing strDeviceName parameter for PFX container", "GetSignMessage");
                        return null;
                    }
                    SignedData = cBIT_PKCS11CL3.SignDataP12(cert, Math.toIntExact(nSlotID), strPIN, rawData, true, strDeviceName, hol);
                } else {
                    String strDLL = BIT_PKCS11CL3.Av337PathChip;
                    if (strType.equalsIgnoreCase("Prog")) {
                        strDLL = BIT_PKCS11CL3.Av337PathProg;
                    }
                    SignedData = cBIT_PKCS11CL3.SignData(cert, nSlotID, strPIN, rawData, true, strDLL, hol);
                }
                if (SignedData != null && ((content = BIT_PKCS11CL3.VerifySign(SignedData, si = new Holder<SignerInfo[]>(arrSi = new SignerInfo[0]), hol)) == null || si.value == null || ((SignerInfo[])si.value).length == 0)) {
                    if (hol.value == null || hol.value == "") {
                        hol.value = "\u041d\u0435\u0432\u0456\u0440\u043d\u0438\u0439 \u043f\u0456\u0434\u043f\u0438\u0441";
                    }
                    SignedData = null;
                }
                if (SignedData == null) {
                    BIT_PKCS11CL3.SetError(hol, "GetSignMessage");
                    return null;
                }
                return BIT_PKCS11CL3.getBase64(SignedData);
            }
        });
    }

    public int CheckPin(long nSlotID, String strType, String strPIN) {
        return this.CheckPin(nSlotID, strType, strPIN, null);
    }

    public int CheckPin(long nSlotID, String strType, String strPIN, String DeviceName) {
        if (strType.equalsIgnoreCase("PFX")) {
            return cBIT_PKCS11CL3.CheckPinP12(Math.toIntExact(nSlotID), DeviceName, strPIN) ? 1 : 0;
        }
        String strDLL = BIT_PKCS11CL3.Av337PathChip;
        if (strType.equalsIgnoreCase("Prog")) {
            strDLL = BIT_PKCS11CL3.Av337PathProg;
        }
        return cBIT_PKCS11CL3.CheckPin(nSlotID, strDLL, strPIN);
    }

    public String[] GetSignMessageFromFile(final String crtBase64, final long nSlotID, final String strPIN, final String strType, final int PacketSize) {
        return AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                if (crtBase64 == null || crtBase64.length() < 1) {
                    BIT_PKCS11CL3.SetError("Certificate not found", "GetSignMessageFromFile");
                    return null;
                }
                byte[] crt = BIT_PKCS11CL3.getBytesFromBase64(crtBase64);
                if (crt == null) {
                    BIT_PKCS11CL3.SetError("Can't convert Certificate from Base64", "GetSignMessageFromFile");
                    return null;
                }
                String strDLL = BIT_PKCS11CL3.Av337PathChip;
                if (strType.equalsIgnoreCase("Prog")) {
                    strDLL = BIT_PKCS11CL3.Av337PathProg;
                }
                Certificate cert = null;
                try {
                    cert = new Certificate(crt);
                }
                catch (Exception ex) {
                    BIT_PKCS11CL3.SetError(ex.getMessage(), "GetSignMessageFromFile");
                    return null;
                }
                if (cert == null) {
                    BIT_PKCS11CL3.SetError("Can't convert Certificate from byte[]", "GetSignMessageFromFile");
                    return null;
                }
                String strError = "";
                Holder<String> hol = new Holder<String>(strError);
                String strFileName = BIT_PKCS11CL3.FileOperation();
                byte[] SignedData = cBIT_PKCS11CL3.SignFileData(cert, nSlotID, strPIN, strFileName, false, strDLL, hol, PacketSize);
                if (SignedData == null) {
                    BIT_PKCS11CL3.SetError(hol, "GetSignMessageFromFile");
                    return null;
                }
                return new String[]{strFileName, BIT_PKCS11CL3.getBase64(SignedData)};
            }
        });
    }

    public String[] GetSignMessageFromFileExt(final String crtBase64, final String cmsBase64, final long nSlotID, final String strPIN, final String strType, final int PacketSize) {
        return AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                if (crtBase64 == null || crtBase64.length() < 1) {
                    BIT_PKCS11CL3.SetError("Certificate not found", "GetSignMessageFromFileExt");
                    return null;
                }
                if (cmsBase64 == null || cmsBase64.length() < 1) {
                    BIT_PKCS11CL3.SetError("Base64CMS not found", "GetSignMessageFromFileExt");
                    return null;
                }
                byte[] crt = BIT_PKCS11CL3.getBytesFromBase64(crtBase64);
                byte[] cms = BIT_PKCS11CL3.getBytesFromBase64(cmsBase64);
                if (crt == null) {
                    BIT_PKCS11CL3.SetError("Can't convert Certificate from Base64", "GetSignMessageFromFileExt");
                    return null;
                }
                if (cms == null) {
                    BIT_PKCS11CL3.SetError("Can't convert CMS from Base64", "GetSignMessageFromFileExt");
                    return null;
                }
                String strDLL = BIT_PKCS11CL3.Av337PathChip;
                if (strType.equalsIgnoreCase("Prog")) {
                    strDLL = BIT_PKCS11CL3.Av337PathProg;
                }
                Certificate cert = null;
                try {
                    cert = new Certificate(crt);
                }
                catch (Exception ex) {
                    BIT_PKCS11CL3.SetError(ex.getMessage(), "GetSignMessageFromFileExt");
                    return null;
                }
                if (cert == null) {
                    BIT_PKCS11CL3.SetError("Can't convert Certificate from byte[]", "GetSignMessageFromFileExt");
                    return null;
                }
                String strError = "";
                Holder<String> hol = new Holder<String>(strError);
                String strFileName = BIT_PKCS11CL3.FileOperation();
                byte[] SignedData = cBIT_PKCS11CL3.SignFileDataExt(cms, cert, nSlotID, strPIN, strFileName, strDLL, hol, PacketSize);
                if (SignedData == null) {
                    BIT_PKCS11CL3.SetError(hol, "GetSignMessageFromFileExt");
                    return null;
                }
                return new String[]{strFileName, BIT_PKCS11CL3.getBase64(SignedData)};
            }
        });
    }

    public String GetSignMessageFromFileExtWithPath(final String strFileName, final String crtBase64, final String cmsBase64, final long nSlotID, final String strPIN, final String strType, final int PacketSize) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                if (crtBase64 == null || crtBase64.length() < 1) {
                    BIT_PKCS11CL3.SetError("Certificate not found", "GetSignMessageFromFileExtWithPath");
                    return null;
                }
                if (cmsBase64 == null || cmsBase64.length() < 1) {
                    BIT_PKCS11CL3.SetError("Base64CMS not found", "GetSignMessageFromFileExtWithPath");
                    return null;
                }
                try {
                    File xyz = new File(strFileName);
                    if (xyz == null || !xyz.exists() || !xyz.canRead()) {
                        BIT_PKCS11CL3.SetError("Can't open file", "GetSignMessageFromFileExtWithPath");
                        return null;
                    }
                }
                catch (Exception ex) {
                    BIT_PKCS11CL3.SetError(ex.getMessage(), "GetSignMessageFromFileExtWithPath");
                    return null;
                }
                byte[] crt = BIT_PKCS11CL3.getBytesFromBase64(crtBase64);
                byte[] cms = BIT_PKCS11CL3.getBytesFromBase64(cmsBase64);
                if (crt == null) {
                    BIT_PKCS11CL3.SetError("Can't convert Certificate from Base64", "GetSignMessageFromFileExt");
                    return null;
                }
                if (cms == null) {
                    BIT_PKCS11CL3.SetError("Can't convert CMS from Base64", "GetSignMessageFromFileExtWithPath");
                    return null;
                }
                String strDLL = BIT_PKCS11CL3.Av337PathChip;
                if (strType.equalsIgnoreCase("Prog")) {
                    strDLL = BIT_PKCS11CL3.Av337PathProg;
                }
                Certificate cert = null;
                try {
                    cert = new Certificate(crt);
                }
                catch (Exception ex) {
                    BIT_PKCS11CL3.SetError(ex.getMessage(), "GetSignMessageFromFileExtWithPath");
                    return null;
                }
                if (cert == null) {
                    BIT_PKCS11CL3.SetError("Can't convert Certificate from byte[]", "GetSignMessageFromFileExtWithPath");
                    return null;
                }
                String strError = "";
                Holder<String> hol = new Holder<String>(strError);
                byte[] SignedData = cBIT_PKCS11CL3.SignFileDataExt(cms, cert, nSlotID, strPIN, strFileName, strDLL, hol, PacketSize);
                if (SignedData == null) {
                    BIT_PKCS11CL3.SetError(hol, "GetSignMessageFromFileExtWithPath");
                    return null;
                }
                return BIT_PKCS11CL3.getBase64(SignedData);
            }
        });
    }

    static {
        if (cBIT_PKCS11CL3 == null) {
            cBIT_PKCS11CL3 = new BIT_PKCS11CL3();
        }
    }
}

